#!/bin/bash
# currently, MingW GCC 9.3 has been tested.
# *** edit this to point to your MingW GCC (cross compile under Linux).
compiler_32="i686-w64-mingw32-gcc"
icoconv_32="i686-w64-mingw32-windres"
# *** derived variables - do not edit
# save current directory
starting_dir=$(pwd)
# change the path to where this script is - useful in case this script
# is being called from somewhere else, like from within an IDE
cd "$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )"
echo "Generating Book Tool 32 bit for Windows."
echo GCC version: $("$compiler_32" -dumpversion)
# *** the source files are fetched relative to the path of this batch file
compiler_options="-m32 -Wall -Wextra -Wlogical-op -Wstrict-prototypes -Wshadow -Werror -O2 -s -std=c99 -fno-strict-aliasing -fno-strict-overflow -fno-common -fno-set-stack-executable -mconsole -static -pie -fPIE -Wl,-e,_mainCRTStartup -Wl,--dynamicbase -Wl,--nxcompat -Wl,-s"
"$compiler_32" $compiler_options -o booktool_win.exe source/*.c
# go back to the starting directory
cd "$starting_dir"
